/* FINAL DRAGON BATTLE MODULE 4/25/05
JESSE HARRIS
HANDLES BATTLES
*/
#include <mygba.h>
#include <hel.h>
#include <iostream.h>

#include "modules.h"
#include "samples.h"

#include "stuff.hpp"
#include "mtwister.h"

extern TCustomTextInfo g_TextInfo;
extern u8 sprites[127];
extern player watashi;
u8 hitthea = 0;
short cursorpos = 0;
short actiondelay = 0;
extern u16 delay;
extern monster monsterlist[];
extern u16 exptable[];
extern chandle g_hChannel;
short enemydelay = 0;
u8 slay = 0;
u8 battlewonmusic = 0;


int myBattle()
{
    char tempy[28];


    hel_PadReadState();
    //action
    
    //---flee---
    if(hel_Pad.Held.A && !delay && cursorpos == 3)
    {
        if(D1d2 == 1)//see if you can flee - you can
        {
            //Sound Effects//85
            g_hChannel = kramPlay(samples[85], 1, g_hChannel);            // Old Handle
            //end Sound Effects
            hel_CustomTextPrint(&g_TextInfo, 2, 13, "You flee");
            hitthea = 1;
            delay = 90;
        }
        else //you fail
        {
            hel_CustomTextPrint(&g_TextInfo, 2, 13, "You cannot flee");
            enemydelay = 90;
            delay = 90;
        }
    }
    //---heal spell---
    if(hel_Pad.Held.A && !delay && cursorpos == 2)
    {
        //if MP
        if(watashi.mp >= 2)
        {
            short number = 4;
            //reduce mp
            watashi.mp = watashi.mp - 2;
            //calculate heal   heal = 2 * level * 1d2
            for(int x = 0; x < watashi.level; x++)
            {
                number = number + D1d3;
            }
            //end calculate damage
            watashi.hp = watashi.hp + number;
            if(watashi.hp > watashi.maxhp)
            {
                watashi.hp = watashi.maxhp;
            }
            sprintf(tempy, "MP: %d/%d ", watashi.mp, watashi.maxmp);
            hel_CustomTextPrint(&g_TextInfo, 16, 17, tempy);
            sprintf(tempy, "HP: %d/%d ", watashi.hp, watashi.maxhp);
            hel_CustomTextPrint(&g_TextInfo, 16, 16, tempy);
            sprintf(tempy, "Heal for %d", number);
            hel_CustomTextPrint(&g_TextInfo, 2, 13, tempy);
            //Sound Effects//85
            g_hChannel = kramPlay(samples[87], 1, g_hChannel);            // Old Handle
            //Sound Effects
            enemydelay = 90;
            delay = 90;
        }
        //if no MP
        else
        {
            hel_CustomTextPrint(&g_TextInfo, 2, 13, "Not enough MP");
            delay = 90;
        }
    }
    //---attack---
    if(hel_Pad.Held.A && !delay && cursorpos == 0)
    {
        short number = 0;
        //calculate damage   damge = level * 1d2
        for(int x = 0; x < watashi.level; x++)
        {
            number = number + D1d2;
        }
        //end calculate damage
        monsterlist[watashi.monster].hp = monsterlist[watashi.monster].hp - number;
        if(monsterlist[watashi.monster].hp < 1)
            {
            monsterlist[watashi.monster].hp = 0;
            hitthea = 1;
            }
        sprintf(tempy, "HP: %d/%d ", monsterlist[watashi.monster].hp, monsterlist[watashi.monster].maxhp);
        hel_CustomTextPrint(&g_TextInfo, 2, 3, tempy);
        //Sound Effects
        g_hChannel = kramPlay(samples[69], 1, g_hChannel);            // Old Handle
        //end Sound Effects
        sprintf(tempy, "Hit %s for %d", monsterlist[watashi.monster].name, number);
        hel_CustomTextPrint(&g_TextInfo, 2, 13, tempy);
        if(monsterlist[watashi.monster].hp == 0)
        {
            //end battle code goes here
            delay = 90;
            slay = 1;
            watashi.exp = watashi.exp + monsterlist[watashi.monster].exp;
            //end end battle code
        }
        else
        {
            enemydelay = 90;
        }
        delay = 90;
    }
    //---hurt spell---
    if(hel_Pad.Held.A && !delay && cursorpos == 1)
    {
        //if MP
        if(watashi.mp >= 3)
        {
            short number = 0;
            //reduce mp
            watashi.mp = watashi.mp - 3;
            //calculate damage   damge = 2 * level * 1d2
            for(int x = 0; x < watashi.level * 2; x++)
            {
                number = number + D1d2;
            }
            //end calculate damage
            monsterlist[watashi.monster].hp = monsterlist[watashi.monster].hp - number;
            if(monsterlist[watashi.monster].hp < 1)
                {
                monsterlist[watashi.monster].hp = 0;
                hitthea = 1;
                }
            sprintf(tempy, "HP: %d/%d ", monsterlist[watashi.monster].hp, monsterlist[watashi.monster].maxhp);
            hel_CustomTextPrint(&g_TextInfo, 2, 3, tempy);
            sprintf(tempy, "MP: %d/%d ", watashi.mp, watashi.maxmp);
            hel_CustomTextPrint(&g_TextInfo, 16, 17, tempy);
            //Sound Effects
            g_hChannel = kramPlay(samples[92], 1, g_hChannel);            // Old Handle
            //end Sound Effects
            sprintf(tempy, "Hit %s for %d", monsterlist[watashi.monster].name, number);
            hel_CustomTextPrint(&g_TextInfo, 2, 13, tempy);
            if(monsterlist[watashi.monster].hp == 0)
            {
                //start end battle process
                delay = 90;
                slay = 1;
                watashi.exp = watashi.exp + monsterlist[watashi.monster].exp;
                //end start end battle process
            }
            else
            {
                enemydelay = 90;
            }
            delay = 90;
        }
        //if no MP
        else
        {
            hel_CustomTextPrint(&g_TextInfo, 2, 13, "Not enough MP");
            delay = 90;
        }
    }
    
   //end action
   //ENEMY ATTACK
    if(enemydelay)
    {
        enemydelay--;
        if(enemydelay == 0)
        {
        short number = 0;
        //calculate damage   damge = level * 1d2
        for(int x = 0; x < monsterlist[watashi.monster].maxhp / 8 + 1; x++)
        {
            number = number + D1d3;
        }
        //end calculate damage


            watashi.hp = watashi.hp - number;
            if(watashi.hp < 1)
            {
                //death code
                watashi.hp = 0;
                //end death code
            }
            sprintf(tempy, "HP: %d/%d ", watashi.hp, watashi.maxhp);
            hel_CustomTextPrint(&g_TextInfo, 16, 16, tempy);
            //Sound Effects
            g_hChannel = kramPlay(samples[69], 1, g_hChannel);            // Old Handle
            //end Sound Effects
            sprintf(tempy, "%s hits for %d  ", monsterlist[watashi.monster].name, number);
            hel_CustomTextPrint(&g_TextInfo, 2, 13, tempy);
            actiondelay = 90;
            delay = 90;
        }
    }
    
    //delay until monster hits you code
    if(actiondelay)
    {
        actiondelay--;
        if(actiondelay == 0)
        {
            if (watashi.hp == 0)
            {
                delay = 30;
                cursorpos = 0;
                return 3;
            }
            hel_CustomTextPrint(&g_TextInfo, 2, 13, "                          ");
        }
    }
    //if hita then exit battle, otherwise
    if(delay == 1  && hitthea)
    {
        if(battlewonmusic == 0)
        {
            ham_DeleteObj(sprites[120]);
            ham_DeleteObj(sprites[121]);
            ham_DeleteObj(sprites[122]);
            ham_DeleteObj(sprites[123]);
            battlewonmusic = 1;
            return 2;
        }


        if(slay) //if you slayed the monster
        {
            hel_CustomTextPrint(&g_TextInfo, 2, 13, "                          ");
            sprintf(tempy, "You gain %d exp", monsterlist[watashi.monster].exp);
            hel_CustomTextPrint(&g_TextInfo, 2, 13, tempy);
            sprintf(tempy, "You slay the %s", monsterlist[watashi.monster].name);
            hel_CustomTextPrint(&g_TextInfo, 2, 12, tempy);
        }
        if(hel_Pad.Held.A  || !slay) //if the monster didn't die or you hit a
        {
        //hel_CustomTextPrint(&g_TextInfo, 2, 13, "                        ");
        //sprintf(tempy, "You gain %d exp", monsterlist[watashi.monster].exp);
        //hel_CustomTextPrint(&g_TextInfo, 2, 13, tempy);
        //sprintf(tempy, "You have slain the %s", monsterlist[watashi.monster].name);
        //hel_CustomTextPrint(&g_TextInfo, 2, 12, tempy);
        //level up code
            //PLOT BLUE DRAGON
            if(watashi.monster == 10)
            {
                return 4; //WIN THE GAME
            }
            //END PLOT BLUE DRAGON
            if(slay) // if the monster did die
                {
                if(watashi.exp >= exptable[watashi.level + 1])
                {
                    watashi.level++;
                    sprintf(tempy, "You are now level %d", watashi.level);
                    hel_CustomTextPrint(&g_TextInfo, 2, 14, tempy);
                    watashi.maxhp = watashi.maxhp + 1 + (watashi.level - 1) * 2;
                    watashi.maxmp = watashi.maxmp + (watashi.level - 1) * 2;
                    watashi.hp = watashi.maxhp;
                    watashi.mp = watashi.maxmp;
                    delay = 90;
                    return 0;
                }
            }
            //end level up code
            ham_SetBgVisible(2,0);
            for(int x = 0; x < 119; x++)
            {
                ham_SetObjVisible(sprites[x], 1);
            }

            cursorpos = 0;
            hel_CustomTextClear(&g_TextInfo);
            delay=20;
            hitthea = 0;
            slay = 0;
            battlewonmusic = 0;
            return 1;
        }
        else
        {
            return 0;
        }
    }
    //end exit code
    //move cursor stuff
    if(hel_Pad.Held.Up && delay == 0)
    {
        //Sound Effects
        g_hChannel = kramPlay(samples[48], 1, g_hChannel);            // Old Handle
        //end Sound Effects
        hel_CustomTextPrint(&g_TextInfo, 2, 7 + cursorpos, " ");
        cursorpos--;
        if(cursorpos == -1)
        {
            cursorpos = 3;
        }
        hel_CustomTextPrint(&g_TextInfo, 2, 7 + cursorpos, ">");
        delay = 10;
    }
    //also move cursor stuff
    if(hel_Pad.Held.Down && delay == 0)
    {
        //Sound Effects
        g_hChannel = kramPlay(samples[48], 1, g_hChannel);            // Old Handle
        //end Sound Effects
        hel_CustomTextPrint(&g_TextInfo, 2, 7 + cursorpos, " ");
        cursorpos++;
        if(cursorpos == 4)
        {
            cursorpos = 0;
        }
        hel_CustomTextPrint(&g_TextInfo, 2, 7 + cursorpos, ">");
        delay = 10;
    }
    //end cusrosr stuff
    if(delay)
    {
        delay--;
        return 0;
    }
    //clear screen where text had come up
    hel_CustomTextPrint(&g_TextInfo, 2, 13, "                          ");
    return 0;
    
}


/* END OF FILE */
